from django import forms
from roocdx import models
from django.forms import widgets


class Cythologist(forms.ModelForm):

    class Meta:
        model = models.Cythologist
        cytologist_id= forms.CharField(required=False, max_length=10, widget=forms.HiddenInput())
        cytologist_user = forms.CharField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))
        phone= forms.CharField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))
        email= forms.EmailField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))
        username = forms.CharField(widget=forms.TextInput(attrs={'class':"form-control", 'placeholder':"Username"}))
        password = forms.CharField(widget=forms.PasswordInput(attrs={'class':"form-control", 'placeholder':"Password"}))
        created_by_user = forms.CharField(required=False)
        created_date = forms.DateField(required=False, widget=forms.widgets.DateInput(format="%m/%d/%Y" , attrs={'class':"form-control"}))
        address = forms.CharField(required=False, max_length=100, widget=forms.TextInput(attrs={'class':"form-control"}))
        address2 = forms.CharField(required=False, max_length=100, widget=forms.TextInput(attrs={'class':"form-control"}))
        city = forms.CharField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))
        state = forms.CharField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))
        zipcode= forms.CharField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))


class Pathologist(forms.ModelForm):
    class Meta:
        model = models.Pathologist
        pathologist_id= forms.CharField(required=False, max_length=10, widget=forms.HiddenInput())
        pathologist_user = forms.CharField(required=False)
        phone= forms.CharField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))
        email= forms.EmailField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))
        username = forms.CharField(widget=forms.TextInput(attrs={'class':"form-control", 'placeholder':"Username"}))
        password = forms.CharField(widget=forms.PasswordInput(attrs={'class':"form-control", 'placeholder':"Password"}))
        created_by_user = forms.CharField(required=False)
        created_date = forms.DateField(required=False, widget=forms.widgets.DateInput(format="%m/%d/%Y" , attrs={'class':"form-control"}))
        address = forms.CharField(required=False, max_length=100, widget=forms.TextInput(attrs={'class':"form-control"}))
        address2 = forms.CharField(required=False, max_length=100, widget=forms.TextInput(attrs={'class':"form-control"}))
        city = forms.CharField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))
        state = forms.CharField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))
        zipcode= forms.CharField(required=False, widget=forms.TextInput(attrs={'class':"form-control"}))

class login(forms.Form):
    username = forms.CharField(widget=forms.TextInput(attrs={'class':"form-control", 'placeholder':"Username"}))
    password = forms.CharField(widget=forms.PasswordInput(attrs={'class':"form-control", 'placeholder':"Password"}))

